/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, afterEach, spyOn */
'use strict';

// Jasmine Unit Testing Suite
define([ "jquery", "backbone", "marionette", "Portal",
    "loader",
    "jquerymobile", "jasminejquery" ],
    function ($, Backbone, Marionette, Portal) {

        describe("Search Applet: Patient List", function () {
            var view,
                viewEl,
                model = new Backbone.Model(),
                collection;

            beforeEach(function () {
                collection = new Backbone.Collection();
                view = new Portal.ListGenerator.PatientListView({
                    model: model,
                    collection: collection,
                    placeholder: "Search..."
                });
                viewEl = view.render().$el;
            });
            afterEach(function () {
                viewEl.remove();
            });

            it("shows the placeholder", function () {
                expect(viewEl.find('input').prop('placeholder')).toEqual("Search...");
            });

            /*
             it("shows a list header", function () {
             view.collection.results = 20;
             view.collection.totalResults = 54;
             view.renderHeader();
             expect(viewEl.find('ul li.ui-li-divider').text()).toBe("Displaying 20 Results of 54 Total");
             });
             */

            it("shows patient information in the list", function () {
                view.collection.add(new Portal.ListGenerator.Patient({
                    displayName: "patient01, zztest",
                    lastName: "patient01",
                    firstName: "zztest",
                    dateOfBirth: "June 16, 1900",
                    age: "110",
                    gender: "FEMALE",
                    ssn: "000-00-0000"
                }));

                var patientEl = viewEl.find('ul li:not(.ui-li-divider)');
                //view.renderHeader();

                expect(patientEl.length).toEqual(1);
                //expect(patientEl.text()).toContain("patient01, zztest");
                //expect(patientEl.text()).toContain("06/16/1900");
                //expect(patientEl.text()).toContain("110 yo");
                //expect(patientEl.text()).toContain("F");
                //expect(patientEl.text()).toContain("000-00-0000");
            });

            /* it("clears the list when the filter is cleared", function () {
             view.collection.add([
             new Portal.ListGenerator.Patient(),
             new Portal.ListGenerator.Patient()
             ]);
             expect(viewEl.find('ul li').length).toEqual(0);
             }); */
            // paging
        });
    });